*-------------------------------------------------------------------------------
*						Fig 4
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Fig 4", replace 
set more off     

**---------------------------------------
* Step1: Generate Data
**---------------------------------------
clear
clear all

//empty file for processed data
set obs 0
save plotdata,replace emptyok

//pop_{o,j,t}
foreach j in "2000" "2015"{
use "`j'census_consistent.dta",clear

gen id_new=_n
collapse (count) id_new,by(consistent title_consistent new new_title)

gen year=`j'
compress
append using plotdata
save plotdata,replace
}

*Merge with skill_o, @version 25.0
use plotdata,clear
merge m:1 consistent using "CHN_cons_to_SOC2010_v25"
keep if _m==3
drop _m

*Construct Index
rename *_std std_*
gen index1_competition=std_Competition
gen index2_interact=(std_interact1 + std_interact2 + std_interact3 + std_interact4)/4
gen index3_cognitive=(std_Cognitive1 + std_Cognitive2 + std_Cognitive3 + std_Cognitive4)/4
gen index4_physical=(std_physical2 + std_physical1)/2
gen index5_routinemanual=(std_routinemanual1+std_routinemanual2+std_routinemanual3)/3
gen index6_routinecognitive=(std_routinecogni1+std_routinecogni2+std_routinecogni3)/3

keep consistent title_consistent new new_title id_new index* year

*Construct employment structure
rename id_new pop
bys new new_title year: egen pop_jt=sum(pop)
bys consistent title_consistent year: egen pop_ot=sum(pop)
bys year: egen pop_t=sum(pop)

gen share_ojt= pop/pop_t
gen o_share_jt= pop/pop_ot
gen j_share_ot= pop/pop_jt

*Define industry type within each occupation
preserve
keep o_share_jt new new_title consistent title_consistent year
reshape wide o_share_jt,i(new new_title consistent title_consistent) j(year)

drop if o_share_jt2000==. & o_share_jt2015==.

foreach j in "2000" "2015"{
replace o_share_jt`j' = 0 if o_share_jt`j' ==.
}

gen d=o_share_jt2015-o_share_jt2000
gen type="职业内行业就业占比上升" if d > 0
replace type="职业内行业就业占比下降" if d < 0
keep new new_title consistent title_consistent type
save within_occ_ind_type.dta,replace
restore

foreach var of varlist index1_competition-index6_routinecognitive{
gen temp_`var'=`var'*j_share_ot
bys year new new_title:egen ind_`var'=sum(temp_`var')
drop temp_`var'
}

keep new new_title consistent title_consistent ind_* year

*Merge with industry type via industry-occ pair
merge m:1 new new_title consistent title_consistent using within_occ_ind_type
tab _m
drop _m consistent title_consistent
duplicates drop

rename ind_* *


**---------------------------------------
* Step2: Plot
**---------------------------------------
twoway (kdensity index3_cognitive if type=="职业内行业就业占比上升" &year==2000,lcolor(red%60) lp(dash)) ///
	   (kdensity index3_cognitive if type=="职业内行业就业占比下降" &year==2000,lcolor(black%60) lp(dash)) ///
	    (kdensity index3_cognitive if type=="职业内行业就业占比上升" &year==2015,lcolor(red) lp(solid)) ///
	    (kdensity index3_cognitive if type=="职业内行业就业占比下降" &year==2015,lcolor(black) lp(solid)), ///
		legend(label(1 "职业内就业占比上升的行业-2000") label(2 "职业内就业占比下降的行业-2000") label(3 "职业内就业占比上升的行业-2015") label(4 "职业内就业占比下降的行业-2015") rows(2) position(6)) ///
	   ytitle("Kdensity") xtitle("认知能力") xlabel(,nogrid) ylabel(,nogrid)  scheme(plotplain)
graph save "$Out_lab\Fig4index3_cognitive",replace
graph export "$Out_lab\Fig4index3_cognitive.png",replace

	   
twoway (kdensity index4_physical if type=="职业内行业就业占比上升" &year==2000,lcolor(red%60) lp(dash)) ///
	   (kdensity index4_physical if type=="职业内行业就业占比下降" &year==2000,lcolor(black%60) lp(dash)) ///
	    (kdensity index4_physical if type=="职业内行业就业占比上升" &year==2015,lcolor(red) lp(solid)) ///
	    (kdensity index4_physical if type=="职业内行业就业占比下降" &year==2015,lcolor(black) lp(solid)), ///
		legend(label(1 "职业内就业占比上升的行业-2000") label(2 "职业内就业占比下降的行业-2000") label(3 "职业内就业占比上升的行业-2015") label(4 "职业内就业占比下降的行业-2015") rows(2) position(6)) ///
	   ytitle("Kdensity") xtitle("体力能力") xlabel(,nogrid) ylabel(,nogrid)  scheme(plotplain)
graph save "$Out_lab\Fig4index4_physical",replace
graph export "$Out_lab\Fig4index4_physical.png",replace


twoway (kdensity index5_routinemanual if type=="职业内行业就业占比上升" &year==2000,lcolor(red%60) lp(dash)) ///
	   (kdensity index5_routinemanual if type=="职业内行业就业占比下降" &year==2000,lcolor(black%60) lp(dash)) ///
	    (kdensity index5_routinemanual if type=="职业内行业就业占比上升" &year==2015,lcolor(red) lp(solid)) ///
	    (kdensity index5_routinemanual if type=="职业内行业就业占比下降" &year==2015,lcolor(black) lp(solid)), ///
		legend(label(1 "职业内就业占比上升的行业-2000") label(2 "职业内就业占比下降的行业-2000") label(3 "职业内就业占比上升的行业-2015") label(4 "职业内就业占比下降的行业-2015") rows(2) position(6)) ///
	   ytitle("Kdensity") xtitle("重复性体力") xlabel(,nogrid) ylabel(,nogrid)  scheme(plotplain)
graph save "$Out_lab\Fig4index5_routinemanual",replace
graph export "$Out_lab\Fig4index5_routinemanual.png",replace


twoway (kdensity index6_routinecognitive if type=="职业内行业就业占比上升" &year==2000,lcolor(red%60) lp(dash)) ///
	   (kdensity index6_routinecognitive if type=="职业内行业就业占比下降" &year==2000,lcolor(black%60) lp(dash)) ///
	    (kdensity index6_routinecognitive if type=="职业内行业就业占比上升" &year==2015,lcolor(red) lp(solid)) ///
	    (kdensity index6_routinecognitive if type=="职业内行业就业占比下降" &year==2015,lcolor(black) lp(solid)), ///
		legend(label(1 "职业内就业占比上升的行业-2000") label(2 "职业内就业占比下降的行业-2000") label(3 "职业内就业占比上升的行业-2015") label(4 "职业内就业占比下降的行业-2015") rows(2) position(6)) ///
	   ytitle("Kdensity") xtitle("重复性认知") xlabel(,nogrid) ylabel(,nogrid)  scheme(plotplain)
graph save "$Out_lab\Fig4index6_routinecognitive",replace
graph export "$Out_lab\Fig4index6_routinecognitive.png",replace


twoway (kdensity index1_competition if type=="职业内行业就业占比上升" &year==2000,lcolor(red%60) lp(dash)) ///
	   (kdensity index1_competition if type=="职业内行业就业占比下降" &year==2000,lcolor(black%60) lp(dash)) ///
	    (kdensity index1_competition if type=="职业内行业就业占比上升" &year==2015,lcolor(red) lp(solid)) ///
	    (kdensity index1_competition if type=="职业内行业就业占比下降" &year==2015,lcolor(black) lp(solid)), ///
		legend(label(1 "职业内就业占比上升的行业-2000") label(2 "职业内就业占比下降的行业-2000") label(3 "职业内就业占比上升的行业-2015") label(4 "职业内就业占比下降的行业-2015") rows(2) position(6)) ///
	   ytitle("Kdensity") xtitle("竞争要求") xlabel(,nogrid) ylabel(,nogrid)  scheme(plotplain)
graph save "$Out_lab\Fig4index1_competition",replace
graph export "$Out_lab\Fig4index1_competition.png",replace



twoway (kdensity index2_interact if type=="职业内行业就业占比上升" &year==2000,lcolor(red%60) lp(dash)) ///
	   (kdensity index2_interact if type=="职业内行业就业占比下降" &year==2000,lcolor(black%60) lp(dash)) ///
	    (kdensity index2_interact if type=="职业内行业就业占比上升" &year==2015,lcolor(red) lp(solid)) ///
	    (kdensity index2_interact if type=="职业内行业就业占比下降" &year==2015,lcolor(black) lp(solid)), ///
		legend(label(1 "职业内就业占比上升的行业-2000") label(2 "职业内就业占比下降的行业-2000") label(3 "职业内就业占比上升的行业-2015") label(4 "职业内就业占比下降的行业-2015") rows(2) position(6)) ///
	   ytitle("Kdensity") xtitle("协同要求") xlabel(,nogrid) ylabel(,nogrid)  scheme(plotplain)
graph save "$Out_lab\Fig4index2_interact",replace
graph export "$Out_lab\Fig4index2_interact.png",replace


*Delet Plotdata
erase plotdata.dta
erase within_occ_ind_type.dta


log close